/*
 * @(#)OMObjectFigure.java  1.0  1. Dezember 2003
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */
package ch.hslu.cm.oo.diagrambsh;

import bsh.*;
import ch.hslu.cm.oo.diagram.OMObjectFigure;
import ch.hslu.cm.oo.*;
import ch.hslu.cm.oo.objectmodel.*;
import ch.hslu.cm.oo.objectmodelbsh.*;
import org.jhotdraw.undo.NonUndoableEdit;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import java.io.*;
import org.jhotdraw.app.action.ActionUtil;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.gui.Worker;

/**
 * ObjectFigureBsh visually represents a {@link OmBshObject}.
 *
 * @author  Werner Randelshofer
 * @version 1.0 1. Dezember 2003  Created.
 */
public class ObjectFigureBsh extends OMObjectFigure {

    private Figure messageBubble;
    private Figure responseBubble;
    private Figure methodBubble;

    @Override
    protected OMObject createSimulatedObject() {
        return new OMBshObject();
    }

    private OMBshObject getModelBsh() {
        return (OMBshObject) getModel();
    }

    private ObjectModelBsh getSimulationBsh() {
        return (ObjectModelBsh) getModel().getSimulation();
    }

    @Override
    public boolean handleDrop(Point2D.Double p, Collection<Figure> droppedFigures, DrawingView view) {
        if (droppedFigures.size() == 1) {
            Figure f = (Figure) droppedFigures.iterator().next();
            if (f instanceof DraggableMessageFigureBsh) {
                final DraggableMessageFigureBsh dmf = (DraggableMessageFigureBsh) f;

                if (getModel().getSimulatedClass() != null) {
                    final String operationName = dmf.getOperationName();
                    Object[] args;
                    try {
                        args = dmf.getArguments((ObjectModel) getModel().getSimulation());
                    } catch (IOException e) {
                        JOptionPane.showMessageDialog((Component) view, "Fehler in Nachricht", e.getMessage(), JOptionPane.ERROR_MESSAGE);
                        return true;
                    }
                    // Find a matching operation
                    ArrayList<OMOperation> operations = new ArrayList<OMOperation>(getModel().getSimulatedClass().getInvokableOperations());
                    OMOperation operation = null;
                    boolean matchingOperationFound = false;
                    for (Iterator i = operations.iterator(); i.hasNext();) {
                        operation = (OMOperation) i.next();
                        if (operation.getOperationName().equals(operationName)) {
                            if (args == null || args.length == operation.getParameterNames().length) {
                                matchingOperationFound = true;
                                break;
                            }
                        }
                    }
                    // Implementation note: When we don't find a matching
                    // operation, we proceed anyway. This is to trigger a
                    // DoesNotUnderstand Exception from the simulated object.


                    // Get arguments from user
                    if (matchingOperationFound && args == null) {
                        String[] parameterNames = operation.getParameterNames();
                        args = new Object[parameterNames.length];
                        if (parameterNames.length > 0) {
                            String[] wrappedArgs = ParameterDialog.show((Component) view, operation.getName(), parameterNames);
                            if (wrappedArgs == null) {
                                return true;
                            }
                            for (int i = 0; i < args.length; i++) {
                                args[i] = getSimulation().unwrapValue(wrappedArgs[i]);
                            }
                        }
                    }

                    final Object[] objArgs = (args == null) ? new Object[0] : args;
                    getModel().getSimulation().invokeBehaviour(new Worker() {

                        @Override
                        public Object construct() {
                            try {
                                getModelBsh().invokeMethod(operationName, objArgs);
                                return Boolean.TRUE;
                            } catch (EvalError e) {
                                return e;
                            }
                        }

                        @Override
                        public void finished() {
                            Object value = getValue();
                            if (value instanceof Throwable) {
                                // to do: escalate to user
                                ((Throwable) value).printStackTrace();
                            }
                            fireUndoableEditHappened(new NonUndoableEdit());
                        }
                    });
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        LinkedList<Action> actions = (LinkedList<Action>) super.getActions(p);
        Action action;

        //Figure compartment = findCompartment(x, y);
        Figure item;

        if (getModel().getSimulatedClass() != null) {
            ArrayList<OMOperation> operations = new ArrayList<OMOperation>(getModel().getSimulatedClass().getInvokableOperations());
            Collections.sort(operations, new Comparator<OMOperation>() {

                @Override
                public int compare(OMOperation a, OMOperation b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            for (Iterator i = operations.iterator(); i.hasNext();) {
                final OMOperation operation = (OMOperation) i.next();
                action = new AbstractAction(operation.getName()) {

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        String[] parameterNames = operation.getParameterNames();
                        final Object[] args = new Object[parameterNames.length];
                        if (parameterNames.length > 0) {
                            String[] stringArgs = ParameterDialog.show((Component) event.getSource(), operation.getName(), parameterNames);
                            if (stringArgs == null) {
                                return;
                            }
                            for (int i = 0; i < args.length; i++) {
                                args[i] = getSimulation().unwrapValue(stringArgs[i]);
                            }
                        }
                        /*
                        for (int i=0; i < args.length; i++) {
                        String argument = JOptionPane.showInputDialog((Component) event.getSource(), parameterNames[i]);
                        if (argument == null) return;
                        args[i] = getSimulation().unwrapValue(argument);
                        }*/
                        getModel().getSimulation().invokeBehaviour(new Runnable() {

                            @Override
                            public void run() {
                                try {
                                    getModelBsh().invokeMethod(operation.getOperationName(), args);
                                } catch (EvalError e) {
                                    e.printStackTrace();
                                    // TO DO: Escalate to User
                                }
                                fireUndoableEditHappened(new NonUndoableEdit());
                            }
                        });
                    }
                };
                action.putValue(ActionUtil.SUBMENU_KEY, "Operation ausf\u00fchren");
                actions.add(action);
            }
        }

        return actions;
    }

    @Override
    public void transmittingMessage(OMObjectEvent evt) {
    }

    @Override
    public void messageTransmitted(OMObjectEvent evt) {
    }

    @Override
    public void methodEntered(OMObjectEvent evt) {
        synchronized (getLock()) {
            set(FILL_COLOR, ClassDiagram.OBJECT_ACTIVE_FILL_COLOR);
            set(STROKE_COLOR, ClassDiagram.OBJECT_ACTIVE_STROKE_COLOR);
        }
    }

    @Override
    public void methodExited(OMObjectEvent evt) {
        synchronized (getLock()) {
            set(FILL_COLOR, ClassDiagram.OBJECT_FILL_COLOR);
            set(STROKE_COLOR, ClassDiagram.OBJECT_STROKE_COLOR);
        }
    }

    @Override
    public void transmittingResponse(OMObjectEvent evt) {
        synchronized (getLock()) {
            if (getSimulation().getDelay() != 0
                    && responseBubble == null && evt.getResponse() != Void.TYPE && evt.getResponse() != Primitive.VOID) {
                getDiagram().add(
                        responseBubble = new ResponseBubble(this, getSimulation().wrapValue(
                        Primitive.unwrap(evt.getResponse())), evt.isException()));
            }
        }
    }

    @Override
    public void responseTransmitted(OMObjectEvent evt) {
        synchronized (getLock()) {
            if (responseBubble != null) {
                getDiagram().remove(responseBubble);
                responseBubble = null;
            }
            if (methodBubble != null) {
                //methodBubble.setVisible(true);
            }
        }
    }
}
